/* first from the abbreviated file I cleaned myself, t-s of Kurzarbeiter hours
  use seasonally UNadjusted
*/
use /Users/hunt/Desktop/Nervecenter/research/BPEA_recession/data/IAB/arbeitszeit_q_seas.dta

* KA - drop 1991 with outlying obs that ruin graph
label var year_q "Year"
*twoway line kurzarbeit_w kurzarbeit_u year_q if year~=1991,scheme(s1color) xlabel(1970 1975 1980 1985 1990 1995 2000 2005 2010) saving(kurz,replace) ytitle("Millions of hours (seasonally unadjusted)") legend(off)  ylabel(0 20 40 60 80 100 120 140 160 180)

* Michael prefers to keep 1991

*twoway line kurzarbeit_w kurzarbeit_u year_q,scheme(s1color) xlabel(1970 1975 1980 1985 1990 1995 2000 2005 2010) saving(kurz,replace) ytitle("Millions of hours (seasonally unadjusted)") legend(off)  ylabel(0 50 100 150 200 250 300 350 400 450 500)

twoway line kurzarbeit_w kurzarbeit_u year_q,scheme(s1mono) xlabel(1970 1975 1980 1985 1990 1995 2000 2005 2010) saving(kurz,replace) ytitle("Millions of hours") legend(off)  ylabel(0 50 100 150 200 250 300 350 400 450 500) lcolor(gs3 gs3)

graph export kurz.eps, replace logo(off) mag(140)
/*
* attempt to have a scale break  - hmm, doesn't look that great
twoway line kurzarbeit_u kurzarbeit_w year_q if year<=1990|year_q>=1992,saving(kurz1,replace) legend(off) xlabel(1970 1975 1980 1985 1990 1995 2000 2005 2010) scheme(s1color) ylabel(0 20 40 60 80 100 120 140 160)
twoway line kurzarbeit_u year_q if year_q>=1991&year<=1991.75,saving(kurz2,replace)  fysize(18)  ytitle(" ") xscale(off) ylabel(300 500) scheme(s1color)
*ylabel(" " 300 500,labgap(*3) notick)
graph combine kurz2.gph kurz1.gph, xcommon rows(2) imargin(tiny)

* KA and overtime
*twoway line kurzarbeit_w kurzarbeit_u uberstunden_w uberstunden_u  year_q,scheme(s1color) xlabel(1970 1975 1980 1985 1990 1995 2000 2005 2010) saving(kurz_uber,replace) yline(180)
*graph export kurz_uber.ps,as(ps) replace logo(off) mag(140) orientation(landscape)
